<?php
require 'db_config.php';

// Récupérer les trois derniers billets
$stmt = $pdo->query("SELECT billets.id, billets.titre, billets.contenu, billets.date_post, utilisateurs.login
                     FROM billets 
                     JOIN utilisateurs ON billets.auteur_id = utilisateurs.id
                     ORDER BY billets.date_post DESC
                     LIMIT 3");
$billets = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Accueil - Mon Blog</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f5f5f5; padding: 20px; }
        .container { max-width: 600px; margin: auto; }
        .billet { background-color: #fff; padding: 20px; margin-bottom: 15px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .titre { font-size: 1.5em; color: #333; }
        .date { color: #777; font-size: 0.9em; margin-bottom: 10px; }
        .contenu { margin-top: 10px; color: #555; }
        .commentaires { margin-top: 10px; padding: 10px; background-color: #f9f9f9; border-radius: 5px; }
        .commentaire { margin-bottom: 10px; }
        .btn-toggle, .btn-login, .btn-archive { margin-top: 10px; padding: 8px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .btn-toggle { width: auto; }
        .btn-login { position: absolute; top: 20px; right: 20px; padding: 10px 20px; }
        .btn-archive { position: absolute; top: 70px; right: 20px; padding: 10px 20px; }
        .btn-toggle:hover, .btn-login:hover, .btn-archive:hover { background-color: #0056b3; }
    </style>
    <script>
        // Afficher et Masquer les commentaires
        function toggleComments(id) {
            var commentsDiv = document.getElementById('comments-' + id);
            var button = document.getElementById('btn-toggle-' + id);
            if (commentsDiv.style.display === 'none') {
                commentsDiv.style.display = 'block';
                button.textContent = 'Masquer les commentaires';
            } else {
                commentsDiv.style.display = 'none';
                button.textContent = 'Afficher les commentaires';
            }
        }
    </script>
</head>
<body>

<div class="container">
    <a href="login.html" class="btn-login">Connexion</a>

    <a href="archive.php" class="btn-archive">Page Archives</a>
    
    <h1>Bienvenue sur mon blog !</h1>

    <!-- Afficher les trois derniers billets -->
    <?php if (!empty($billets)): ?>
        <?php foreach ($billets as $billet): ?>
            <div class="billet">
                <div class="titre"><?= htmlspecialchars($billet['titre']) ?></div>
                <div class="date">Posté par <?= htmlspecialchars($billet['login']) ?> le <?= htmlspecialchars($billet['date_post']) ?></div>
                <div class="contenu"><?= nl2br(htmlspecialchars($billet['contenu'])) ?></div>

                <!-- Bouton pour afficher et masquer les commentaires -->
                <button class="btn-toggle" id="btn-toggle-<?= $billet['id'] ?>" onclick="toggleComments(<?= $billet['id'] ?>)">Afficher les commentaires</button>

                
                <div class="commentaires" id="comments-<?= $billet['id'] ?>" style="display: none;">
                    <h4>Commentaires :</h4>

                    <?php
                    // Récupérer les commentaires associés au billet
                    $stmt = $pdo->prepare("SELECT commentaires.contenu, commentaires.date_post, utilisateurs.login 
                                           FROM commentaires 
                                           JOIN utilisateurs ON commentaires.auteur_id = utilisateurs.id 
                                           WHERE commentaires.billet_id = :billet_id
                                           ORDER BY commentaires.date_post ASC");
                    $stmt->execute(['billet_id' => $billet['id']]);
                    $commentaires = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    if ($commentaires):
                        foreach ($commentaires as $commentaire):
                    ?>
                        <div class="commentaire">
                            <strong><?= htmlspecialchars($commentaire['login']) ?></strong> le <?= htmlspecialchars($commentaire['date_post']) ?> :<br>
                            <?= nl2br(htmlspecialchars($commentaire['contenu'])) ?>
                        </div>
                    <?php
                        endforeach;
                    else:
                        echo "<p>Aucun commentaire pour ce billet.</p>";
                    endif;
                    ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>Aucun billet disponible pour le moment.</p>
    <?php endif; ?>
</div>

</body>
</html>
