<?php
require 'db_config.php';

// Vérification si l'utilisateur est l'admin
function estAdmin($pdo, $user_id) {
    $stmt = $pdo->prepare("SELECT email FROM utilisateurs WHERE id = ?");
    $stmt->execute([$user_id]);
    $utilisateur = $stmt->fetch(PDO::FETCH_ASSOC);
    return $utilisateur && $utilisateur['email'] === 'toto@gmail.com';
}

// Publication d'un commentaire
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['billet_id'], $_POST['contenu_commentaire'])) {
    if (isset($_SESSION['utilisateur_id'])) {
        $billet_id = intval($_POST['billet_id']);
        $contenu = trim($_POST['contenu_commentaire']);
        $auteur_id = intval($_SESSION['utilisateur_id']);

        if (!empty($contenu)) {
            $stmt = $pdo->prepare("INSERT INTO commentaires (contenu, auteur_id, billet_id) VALUES (?, ?, ?)");
            $stmt->execute([$contenu, $auteur_id, $billet_id]);
            $_SESSION['message'] = "Commentaire ajouté avec succès.";
        } else {
            $_SESSION['message'] = "Le contenu du commentaire ne peut pas être vide.";
        }
    } else {
        $_SESSION['message'] = "Vous devez être connecté pour commenter.";
    }
    header('Location: commentaires.php');
    exit();
}

// Récupération des billets
$billets = $pdo->query("
    SELECT b.*, u.login AS auteur_login
    FROM billets b
    JOIN utilisateurs u ON b.auteur_id = u.id
    ORDER BY b.date_post DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Récupération des commentaires associés
$commentaires = $pdo->query("
    SELECT c.*, u.login AS auteur_login
    FROM commentaires c
    LEFT JOIN utilisateurs u ON c.auteur_id = u.id
    ORDER BY c.date_post ASC
")->fetchAll(PDO::FETCH_GROUP | PDO::FETCH_ASSOC);

?>
