<?php
session_start();

require 'db_config.php';

// Vérification de la connexion et des droits administrateur
$isConnected = isset($_SESSION['utilisateur_id']);
$isAdmin = $isConnected && $_SESSION['role'] === 'admin' && $_SESSION['login'] === 'toto@gmail.com';

// Traitement du formulaire de création/modification/suppression de billet (uniquement pour l'administrateur)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $isAdmin) {
    $action = $_POST['action'];

    if ($action === 'ajouter' && isset($_POST['titre'], $_POST['contenu'])) {
        // Ajouter un nouveau billet, seulement si c'est l'administrateur
        $titre = $_POST['titre'];
        $contenu = $_POST['contenu'];
        $auteur_id = $_SESSION['utilisateur_id'];
        
        $stmt = $pdo->prepare("INSERT INTO billets (titre, contenu, auteur_id) VALUES (:titre, :contenu, :auteur_id)");
        $stmt->bindParam(':titre', $titre);
        $stmt->bindParam(':contenu', $contenu);
        $stmt->bindParam(':auteur_id', $auteur_id);
        $stmt->execute();
        
        header("Location: billets.php");
        exit();
    } elseif ($action === 'modifier' && isset($_POST['billet_id'], $_POST['nouveau_titre'], $_POST['nouveau_contenu'])) {
        // Modifier un billet, seulement si c'est l'administrateur
        $billet_id = $_POST['billet_id'];
        $nouveau_titre = $_POST['nouveau_titre'];
        $nouveau_contenu = $_POST['nouveau_contenu'];
        
        $stmt = $pdo->prepare("UPDATE billets SET titre = :titre, contenu = :contenu WHERE id = :id AND auteur_id = :auteur_id");
        $stmt->bindParam(':titre', $nouveau_titre);
        $stmt->bindParam(':contenu', $nouveau_contenu);
        $stmt->bindParam(':id', $billet_id);
        $stmt->bindParam(':auteur_id', $_SESSION['utilisateur_id']);
        $stmt->execute();
        
        header("Location: billets.php");
        exit();
    } elseif ($action === 'supprimer' && isset($_POST['billet_id'])) {
        // Supprimer un billet et ses commentaires, seulement si c'est l'administrateur
        $billet_id = $_POST['billet_id'];
        
        // Supprimer les commentaires associés au billet
        $stmt = $pdo->prepare("DELETE FROM commentaires WHERE billet_id = :billet_id");
        $stmt->bindParam(':billet_id', $billet_id);
        $stmt->execute();

        // Supprimer le billet
        $stmt = $pdo->prepare("DELETE FROM billets WHERE id = :id AND auteur_id = :auteur_id");
        $stmt->bindParam(':id', $billet_id);
        $stmt->bindParam(':auteur_id', $_SESSION['utilisateur_id']);
        $stmt->execute();
        
        header("Location: billets.php");
        exit();
    }
}

// Récupérer tous les billets
$stmt = $pdo->query("SELECT billets.id, billets.titre, billets.contenu, billets.date_post, utilisateurs.login, billets.auteur_id
                     FROM billets 
                     JOIN utilisateurs ON billets.auteur_id = utilisateurs.id
                     ORDER BY billets.date_post DESC");
$billets = $stmt->fetchAll(PDO::FETCH_ASSOC);


include 'affichage_billets.php';
?>