<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des billets</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f5f5f5; padding: 20px; }
        .container { max-width: 600px; margin: auto; }
        .billet { background-color: #fff; padding: 20px; margin-bottom: 15px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .titre { font-size: 1.5em; color: #333; }
        .date { color: #777; font-size: 0.9em; margin-bottom: 10px; }
        .contenu { margin-top: 10px; color: #555; }
        .formulaire-billet { background-color: #fff; padding: 20px; margin-bottom: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; color: #333; }
        input[type="text"], textarea { width: 100%; padding: 8px; box-sizing: border-box; }
        .btn { width: 100%; padding: 10px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .btn-edit { background-color: #28a745; }
        .btn-delete { background-color: #dc3545; margin-top: 10px; }
        
        .btn-accueil {
            position: absolute;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff; 
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none; 
            font-size: 1em;
        }
        .btn-accueil:hover {
            background-color: #0056b3; 
        }
    </style>
</head>
<body>

<div class="container">
    
    <a href="index.php" class="btn-accueil">Accueil</a>

    <h1>Liste des billets</h1>

    <?php if (isset($_SESSION['login']) && $_SESSION['login'] === 'toto@gmail.com'): ?>
        <!-- Formulaire pour ajouter un billet (uniquement pour l'administrateur) -->
        <div class="formulaire-billet">
            <h2>Ajouter un nouveau billet</h2>
            <form action="billets.php" method="POST">
                <input type="hidden" name="action" value="ajouter">
                <div class="form-group">
                    <label for="titre">Titre :</label>
                    <input type="text" id="titre" name="titre" required>
                </div>
                <div class="form-group">
                    <label for="contenu">Contenu :</label>
                    <textarea id="contenu" name="contenu" rows="5" required></textarea>
                </div>
                <button type="submit" class="btn">Publier le billet</button>
            </form>
        </div>
    <?php endif; ?>

    
    <?php foreach ($billets as $billet): ?>
        <div class="billet">
            <div class="titre"><?= htmlspecialchars($billet['titre']) ?></div>
            <div class="date">Posté par <?= htmlspecialchars($billet['login']) ?> le <?= htmlspecialchars($billet['date_post']) ?></div>
            <div class="contenu"><?= nl2br(htmlspecialchars($billet['contenu'])) ?></div>
            
            <?php if (isset($_SESSION['login']) && $_SESSION['login'] === 'toto@gmail.com'): ?>
                <!-- Boutons pour éditer et supprimer le billet (uniquement pour l'administrateur) -->
                <button class="btn btn-edit" onclick="document.getElementById('edit-form-<?= $billet['id'] ?>').style.display='block'">Modifier</button>
                <form action="billets.php" method="POST" style="display: inline;">
                    <input type="hidden" name="action" value="supprimer">
                    <input type="hidden" name="billet_id" value="<?= $billet['id'] ?>">
                    <button type="submit" class="btn btn-delete">Supprimer</button>
                </form>
                
                <!-- modification billet -->
                <div id="edit-form-<?= $billet['id'] ?>" style="display:none; margin-top: 10px;">
                    <form action="billets.php" method="POST">
                        <input type="hidden" name="action" value="modifier">
                        <input type="hidden" name="billet_id" value="<?= $billet['id'] ?>">
                        <div class="form-group">
                            <label for="nouveau_titre">Titre :</label>
                            <input type="text" name="nouveau_titre" value="<?= htmlspecialchars($billet['titre']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="nouveau_contenu">Contenu :</label>
                            <textarea name="nouveau_contenu" rows="5" required><?= htmlspecialchars($billet['contenu']) ?></textarea>
                        </div>
                        <button type="submit" class="btn btn-edit">Enregistrer les modifications</button>
                    </form>
                </div>
            <?php endif; ?>

            <!-- Formulaire pour ajouter un commentaire (pour tous les utilisateurs connectés) -->
            <?php if (isset($_SESSION['utilisateur_id'])): ?>
                <div class="formulaire-billet" style="margin-top: 10px;">
                    <h3>Ajouter un commentaire</h3>
                    <form action="commentaires.php" method="POST">
                        <input type="hidden" name="billet_id" value="<?= $billet['id'] ?>">
                        <div class="form-group">
                            <label for="contenu_commentaire">Commentaire :</label>
                            <textarea id="contenu_commentaire" name="contenu_commentaire" rows="3" required></textarea>
                        </div>
                        <button type="submit" class="btn">Publier le commentaire</button>
                    </form>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>

</body>
</html>